using System;
using System.Data;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;
using Microsoft.Reporting.WinForms;
using System.Reflection;
using System.IO;

namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// Class FrmCTRatioReport
	/// </summary>
	public class FrmCTRatioReport : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		private BOL.CTRatioReport _report;
		//
        private System.Windows.Forms.GroupBox grpImage;
		private System.Windows.Forms.Button btnCancel;
		private System.Windows.Forms.Button btnPrint;
		private System.Windows.Forms.PictureBox pictureBox1;
		private System.Windows.Forms.PrintDialog printDialog1;
        private gov.va.med.vbecs.GUI.controls.VbecsReportViewer rvCTRatioReport;
		private System.ComponentModel.IContainer components = null;
        DataSet _dsReport = new DataSet();

		/// <summary>
		/// Constructor
		/// </summary>
		/// <param name="report"></param>
		public FrmCTRatioReport(BOL.CTRatioReport report)
		{
			InitializeComponent();
			//
			this._report = report;
			//
			SetComponentProperties();
			//
			using (new WaitCursor())
			{
				this.CreateReport();
			}
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(FrmCTRatioReport));
            this.grpImage = new System.Windows.Forms.GroupBox();
            this.pictureBox1 = new System.Windows.Forms.PictureBox();
            this.btnCancel = new System.Windows.Forms.Button();
            this.btnPrint = new System.Windows.Forms.Button();
            this.printDialog1 = new System.Windows.Forms.PrintDialog();
            this.rvCTRatioReport = new gov.va.med.vbecs.GUI.controls.VbecsReportViewer();
            ((System.ComponentModel.ISupportInitialize)(this.errError)).BeginInit();
            this.grpImage.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.pictureBox1)).BeginInit();
            this.SuspendLayout();
            // 
            // vbecsLogo1
            // 
            this.vbecsLogo1.TabIndex = 3;
            this.vbecsLogo1.Title = "C:T Ratio Report";
            // 
            // lblRequiredField
            // 
            this.lblRequiredField.Location = new System.Drawing.Point(0, 452);
            this.lblRequiredField.TabIndex = 5;
            // 
            // grpImage
            // 
            this.grpImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left)));
            this.grpImage.BackColor = System.Drawing.SystemColors.Control;
            this.grpImage.Controls.Add(this.pictureBox1);
            this.grpImage.Location = new System.Drawing.Point(4, 32);
            this.grpImage.Name = "grpImage";
            this.grpImage.Size = new System.Drawing.Size(52, 403);
            this.grpImage.TabIndex = 4;
            this.grpImage.TabStop = false;
            // 
            // pictureBox1
            // 
            this.pictureBox1.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox1.Image")));
            this.pictureBox1.Location = new System.Drawing.Point(4, 12);
            this.pictureBox1.Name = "pictureBox1";
            this.pictureBox1.Size = new System.Drawing.Size(45, 45);
            this.pictureBox1.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
            this.pictureBox1.TabIndex = 1;
            this.pictureBox1.TabStop = false;
            // 
            // btnCancel
            // 
            this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
            this.btnCancel.Location = new System.Drawing.Point(564, 439);
            this.btnCancel.Name = "btnCancel";
            this.btnCancel.Size = new System.Drawing.Size(75, 23);
            this.btnCancel.TabIndex = 2;
            this.btnCancel.Text = "&Close";
            this.btnCancel.Click += new System.EventHandler(this.CloseClick);
            // 
            // btnPrint
            // 
            this.btnPrint.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnPrint.DialogResult = System.Windows.Forms.DialogResult.OK;
            this.btnPrint.Image = ((System.Drawing.Image)(resources.GetObject("btnPrint.Image")));
            this.btnPrint.ImageAlign = System.Drawing.ContentAlignment.MiddleLeft;
            this.btnPrint.Location = new System.Drawing.Point(484, 439);
            this.btnPrint.Name = "btnPrint";
            this.btnPrint.Size = new System.Drawing.Size(75, 23);
            this.btnPrint.TabIndex = 1;
            this.btnPrint.Text = "&Print";
            this.btnPrint.Click += new System.EventHandler(this.PrintClick);
            // 
            // printDialog1
            // 
            this.printDialog1.AllowPrintToFile = false;
            this.printDialog1.AllowSomePages = true;
            // 
            // rvCTRatioReport
            // 
            this.rvCTRatioReport.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.rvCTRatioReport.Location = new System.Drawing.Point(60, 37);
            this.rvCTRatioReport.Name = "rvCTRatioReport";
            this.rvCTRatioReport.Size = new System.Drawing.Size(579, 396);
            this.rvCTRatioReport.TabIndex = 6;
            this.rvCTRatioReport.RenderingComplete += new Microsoft.Reporting.WinForms.RenderingCompleteEventHandler(this.rvCTRatioReport_RenderingComplete);
            this.rvCTRatioReport.RenderingBegin += new System.ComponentModel.CancelEventHandler(this.rvCTRatioReport_RenderingBegin);
            // 
            // FrmCTRatioReport
            // 
            this.AcceptButton = this.btnPrint;
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.CancelButton = this.btnCancel;
            this.ClientSize = new System.Drawing.Size(642, 466);
            this.Controls.Add(this.rvCTRatioReport);
            this.Controls.Add(this.grpImage);
            this.Controls.Add(this.btnCancel);
            this.Controls.Add(this.btnPrint);
            this.hlphelpChm.SetHelpKeyword(this, "Reports_UC_104.htm#ViewPrint");
            this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
            this.MinimumSize = new System.Drawing.Size(300, 300);
            this.Name = "FrmCTRatioReport";
            this.RequiredFieldsLabel = true;
            this.hlphelpChm.SetShowHelp(this, true);
            this.Text = "VBECS - C:T Ratio Report";
            this.Load += new System.EventHandler(this.FrmCTRatioReport_Load);
            this.Controls.SetChildIndex(this.vbecsLogo1, 0);
            this.Controls.SetChildIndex(this.lblRequiredField, 0);
            this.Controls.SetChildIndex(this.btnPrint, 0);
            this.Controls.SetChildIndex(this.btnCancel, 0);
            this.Controls.SetChildIndex(this.grpImage, 0);
            this.Controls.SetChildIndex(this.rvCTRatioReport, 0);
            ((System.ComponentModel.ISupportInitialize)(this.errError)).EndInit();
            this.grpImage.ResumeLayout(false);
            this.grpImage.PerformLayout();
            ((System.ComponentModel.ISupportInitialize)(this.pictureBox1)).EndInit();
            this.ResumeLayout(false);
            this.PerformLayout();

		}
		#endregion

		private void SetComponentProperties()
		{
			this.vbecsLogo1.Title = this.Text.Replace("VBECS - ","");
			//
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC104.FrmCTRatioReport());
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
            BOL.VbecsReport.SetUpReportButtons(this.rvCTRatioReport);
        }

		private void CreateReport()
		{
            _dsReport = this._report.GenerateReport();
            DataSet dsHeader = BOL.VbecsReport.GetReportHeader(ThisUser.UserName);
            DataSet dsFooter = BOL.VbecsReport.GetReportFooter(this._report.ReportCriteria);

            ReportDataSource reportSourceMain = new ReportDataSource();
            if (_dsReport.Tables.Count > 0)
            {
                reportSourceMain.Name = "CTRatioReportDataSet";
                reportSourceMain.Value = _dsReport.Tables[0];
            }

            ReportDataSource reportSourceHeader = new ReportDataSource();
            if (dsHeader.Tables.Count > 0)
            {
                reportSourceHeader.Name = "ReportHeaderDataSet";
                reportSourceHeader.Value = dsHeader.Tables[0];
            }

            ReportDataSource reportSourceFooter = new ReportDataSource();
            if (dsFooter.Tables.Count > 0)
            {
                reportSourceFooter.Name = "ReportFooterDataSet";
                reportSourceFooter.Value = dsFooter.Tables[0];
            }

            Assembly assembly = Assembly.LoadFrom("Reports.dll");
            Stream stream = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.CTRatioReport.CTRatioReport.rdlc");
            Stream streamDetailed = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.CTRatioReport.CTRatioDetailed.rdlc");
            Stream streamPhysician = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.CTRatioReport.CTRatioPhysicianSummary.rdlc");
            Stream streamSpecialty = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.CTRatioReport.CTRatioSpecialtySummary.rdlc");

            this.rvCTRatioReport.LocalReport.SubreportProcessing += new SubreportProcessingEventHandler(LoadSubreportsEventHandler);

            this.rvCTRatioReport.LocalReport.DataSources.Add(reportSourceMain);
            this.rvCTRatioReport.LocalReport.DataSources.Add(reportSourceHeader);
            this.rvCTRatioReport.LocalReport.DataSources.Add(reportSourceFooter);
            this.rvCTRatioReport.LocalReport.LoadReportDefinition(stream);
            this.rvCTRatioReport.LocalReport.LoadSubreportDefinition("CTRatioDetailed", streamDetailed);
            this.rvCTRatioReport.LocalReport.LoadSubreportDefinition("CTRatioPhysicianSummary", streamPhysician);
            this.rvCTRatioReport.LocalReport.LoadSubreportDefinition("CTRatioSpecialtySummary", streamSpecialty);

            this.rvCTRatioReport.RefreshReport();
		}

        private void LoadSubreportsEventHandler(object sender, SubreportProcessingEventArgs e)
        {
            if (e.ReportPath == "CTRatioDetailed" || e.DataSourceNames[0].ToString() == "CTRatioDetailedDataSet")
            {
                ReportDataSource reportSourceDetailed = new ReportDataSource();
                if (_dsReport.Tables.Count > 1)
                {
                    reportSourceDetailed.Name = "CTRatioDetailedDataSet";
                    reportSourceDetailed.Value = _dsReport.Tables[1];
                }
                e.DataSources.Add(reportSourceDetailed);

                ReportDataSource reportSourceMain = new ReportDataSource();
                if (_dsReport.Tables.Count > 0)
                {
                    reportSourceMain.Name = "CTRatioReportDataSet";
                    reportSourceMain.Value = _dsReport.Tables[0];
                }
                e.DataSources.Add(reportSourceMain);
            }
            else if ((e.ReportPath == "CTRatioPhysicianSummary" || e.DataSourceNames[0].ToString() == "CTRatioPhysicianSummaryDataSet") && this._report.IncludePhysicianSummary)
            {
                ReportDataSource reportSourcePhysician = new ReportDataSource();
                if (_dsReport.Tables.Count > 2)
                {
                    reportSourcePhysician.Name = "CTRatioPhysicianSummaryDataSet";
                    reportSourcePhysician.Value = _dsReport.Tables[2];
                }
                e.DataSources.Add(reportSourcePhysician);

                ReportDataSource reportSourceMain = new ReportDataSource();
                if (_dsReport.Tables.Count > 0)
                {
                    reportSourceMain.Name = "CTRatioReportDataSet";
                    reportSourceMain.Value = _dsReport.Tables[0];
                }
                e.DataSources.Add(reportSourceMain);
            }
            else if ((e.ReportPath == "CTRatioSpecialtySummary" || e.DataSourceNames[0].ToString() == "CTRatioSpecialtySummaryDataSet") && this._report.IncludeSpecialtySummary)
            {
                ReportDataSource reportSourceSpecialty = new ReportDataSource();
                if (_dsReport.Tables.Count > 2)
                {
                    reportSourceSpecialty.Name = "CTRatioSpecialtySummaryDataSet";
                    reportSourceSpecialty.Value = _dsReport.Tables[2];
                }
                e.DataSources.Add(reportSourceSpecialty);

                ReportDataSource reportSourceMain = new ReportDataSource();
                if (_dsReport.Tables.Count > 0)
                {
                    reportSourceMain.Name = "CTRatioReportDataSet";
                    reportSourceMain.Value = _dsReport.Tables[0];
                }
                e.DataSources.Add(reportSourceMain);
            }
        }

		private void CloseClick(object sender, System.EventArgs e)
		{
			this.Close();
		}

		private void PrintClick(object sender, System.EventArgs e)
		{
            //CR 3416 CR 3449
            try
            {
                this.rvCTRatioReport.PrintDialog();
            }
            catch (System.InvalidOperationException)
            {
            }
        }

        private void FrmCTRatioReport_Load(object sender, EventArgs e)
        {

            this.rvCTRatioReport.RefreshReport();
        }

        /// <summary>
        /// CR 3581
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void rvCTRatioReport_RenderingBegin(object sender, CancelEventArgs e)
        {
            this.btnPrint.Enabled = false;
        }

        /// <summary>
        /// CR 3581
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void rvCTRatioReport_RenderingComplete(object sender, RenderingCompleteEventArgs e)
        {
            this.btnPrint.Enabled = true;
        }
	}
}

